//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "RestoreProcess_Form.h"
#include "Message_Form.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CGAUGES"
#pragma resource "*.dfm"
TRestoreProcessForm *RestoreProcessForm;
//---------------------------------------------------------------------------
__fastcall TRestoreProcessForm::TRestoreProcessForm(TComponent* Owner)
    : TTntForm(Owner)
{
	BreakActivate = false;
}
//---------------------------------------------------------------------------
int __fastcall TRestoreProcessForm::Execute(AnsiString backupDir, TBackupContents backupContents)
{
	try
    {
    	BackupDir = backupDir;
    	BackupContents = backupContents;
		this->Show();
        RestoreStart();
    }
    catch(...)
    {
		ShowMessageFA("The recovery was interrupted.");
		this->Close();
		return mrCancel;
    }
    ShowMessageFA("Recovery is complete.");
    this->Close();
	return mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TRestoreProcessForm::RestoreStart(void)
{
	CalculateRestoreSpaceLabel->Font->Color = clBlue;
	CalculateRestoreSpaceLabel->Caption = " ";
	Repaint();
	CalculateRestoreSpace();
	CalculateRestoreSpaceLabel->Font->Color = clGreen;
	CalculateRestoreSpaceLabel->Caption = "Ϸ";


	if (BackupContents.Contains(bcUserInfo))
	{
		RestoreUserInfoLabel->Font->Color = clBlue;
		RestoreUserInfoLabel->Caption = " ";
		Repaint();
		RestoreUserInfo();
		RestoreUserInfoLabel->Font->Color = clGreen;
		RestoreUserInfoLabel->Caption = "Ϸ";
	}
	else
	{
		RestoreUserInfoLabel->Font->Color = clBlue;
		RestoreUserInfoLabel->Caption = "";
	}
	if (BackupContents.Contains(bcSystemInfo))
	{
		RestoreSystemInfoLabel->Font->Color = clBlue;
		RestoreSystemInfoLabel->Caption = " ";
		Repaint();
		RestoreSystemInfo();
		RestoreSystemInfoLabel->Font->Color = clGreen;
		RestoreSystemInfoLabel->Caption = "Ϸ";
	}
	else
	{
		RestoreSystemInfoLabel->Font->Color = clBlue;
		RestoreSystemInfoLabel->Caption = "";
	}
	if (BackupContents.Contains(bcProductInfo))
	{
		RestoreProductInfoLabel->Font->Color = clBlue;
		RestoreProductInfoLabel->Caption = " ";
		ProductBackupProgressGroupBox->Visible = true;
		Repaint();
		RestoreProductInfo();
		if (BreakActivate) throw Exception("");
		RestoreProductInfoLabel->Font->Color = clGreen;
		RestoreProductInfoLabel->Caption = "Ϸ";
	}
	else
	{
		RestoreProductInfoLabel->Font->Color = clBlue;
		RestoreProductInfoLabel->Caption = "";
	}
	if (BackupContents.Contains(bcDefectImage))
	{
		RestoreDefectImageLabel->Font->Color = clBlue;
		RestoreDefectImageLabel->Caption = " ";
		Repaint();
		RestoreDefectImage();
		RestoreDefectImageLabel->Font->Color = clGreen;
		RestoreDefectImageLabel->Caption = "Ϸ";
	}
	else
	{
		RestoreDefectImageLabel->Font->Color = clBlue;
		RestoreDefectImageLabel->Caption = "";
	}
}
//---------------------------------------------------------------------------
void __fastcall TRestoreProcessForm::CalculateRestoreSpace(void)
{

}
//---------------------------------------------------------------------------
bool __fastcall TRestoreProcessForm::RestoreUserInfo(void)
{
	if (!DirectoryExists(ProgramPath.Env)) ForceDirectories(ProgramPath.Env);
	
	AnsiString userInfoDir = BackupDir + "\\UserInfo";
	AnsiString sourceFileName = userInfoDir + "\\user.ini";
	AnsiString destFileName = ProgramPath.Env + "\\user.ini";
	CopyFile(sourceFileName.c_str(), destFileName.c_str(), FALSE);
	return true;
}
//---------------------------------------------------------------------------
bool __fastcall TRestoreProcessForm::RestoreSystemInfo(void)
{
	if (!DirectoryExists(ProgramPath.Env)) ForceDirectories(ProgramPath.Env);

	AnsiString fileList[10] = {"VersionInfo.ini", "UserMachineInfor.ini", "Ranger3DCameraInfo.ini",
		"MachineInfor.ini", "SystemInfor.ini", "ShutterSpeedInfor.ini", "ColorCode.ini", "Download.ini",
		"DSMInfor.ini", "SystemSetup.ini"};
	AnsiString systemInfoDir = BackupDir + "\\SystemInfo";
	for (int fileIndex = 0; fileIndex < 10; fileIndex++)
	{
		AnsiString sourceFileName = systemInfoDir + "\\" + fileList[fileIndex];
		AnsiString destFileName = ProgramPath.Env + "\\" + fileList[fileIndex];
		CopyFile(sourceFileName.c_str(), destFileName.c_str(), FALSE);
	}
    return true;    
}
//---------------------------------------------------------------------------
bool __fastcall TRestoreProcessForm::RestoreProductInfo(void)
{
	if (!DirectoryExists(ProgramPath.Product)) ForceDirectories(ProgramPath.Product);

	TSearchRec sr;
    int iAttributes = faDirectory;
	AnsiString sourceDirRoot = BackupDir + "\\Product";
	AnsiString productDir = ProgramPath.Product;

	int productCount = 0;
	if (FindFirst(sourceDirRoot + "\\*.*", iAttributes, sr) == 0)
	{
		do
		{
			if ((sr.Attr & iAttributes) == sr.Attr && sr.Name != "." && sr.Name != "..")
			{
				productCount++;
			}
		} while (FindNext(sr) == 0);
		FindClose(sr);
	}

	int currentProductCount = 0;	

    if (FindFirst(sourceDirRoot + "\\*.*", iAttributes, sr) == 0)
    {
    	do
        {
        	if ((sr.Attr & iAttributes) == sr.Attr && sr.Name != "." && sr.Name != "..")
			{
				ProductNameLabel->Caption = sr.Name;
				if (productCount)
				{
					CGauge1->Progress = currentProductCount * 100 / productCount;
				}
				CopyDir(productDir + "\\" + sr.Name, sourceDirRoot + "\\" + sr.Name);
				currentProductCount++;
			}
        } while (FindNext(sr) == 0);
        FindClose(sr);
    }
    return true;
}
//---------------------------------------------------------------------------
bool __fastcall TRestoreProcessForm::RestoreDefectImage(void)
{

}
//---------------------------------------------------------------------------
void __fastcall TRestoreProcessForm::CopyDir(AnsiString destDir, AnsiString srcDir)
{
	TSearchRec sr;
    int iAttributes = faAnyFile;
    CreateDir(destDir);
    if (FindFirst(srcDir + "\\*.*", iAttributes, sr) == 0)
    {
    	do
        {
        	if (sr.Name == "." || sr.Name == "..") continue;
        	if ((sr.Attr & faDirectory))
            {
	            CopyDir(destDir + "\\" + sr.Name, srcDir + "\\" + sr.Name);
            }
            else
            {
			    AnsiString sourceFileName = srcDir + "\\" + sr.Name;
			    AnsiString destFileName = destDir + "\\" + sr.Name;
			    CopyFile(sourceFileName.c_str(), destFileName.c_str(), FALSE);
			}
			Application->ProcessMessages();
			if (BreakActivate) break;
        } while (FindNext(sr) == 0);
        FindClose(sr);
    }
}
//---------------------------------------------------------------------------


void __fastcall TRestoreProcessForm::BreakButtonClick(TObject *Sender)
{
	BreakActivate = true;	
}
//---------------------------------------------------------------------------

